; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 4
; RUN: llc -global-isel -mtriple=aarch64-linux-gnu -O0 -stop-after=irtranslator < %s | FileCheck %s


define <2 x i1> @call_icmp_samesign_vector(<2 x i32> %a, <2 x i32> %b) {
  ; CHECK-LABEL: name: call_icmp_samesign_vector
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $d0, $d1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<2 x s32>) = COPY $d0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(<2 x s32>) = COPY $d1
  ; CHECK-NEXT:   %2:_(<2 x s1>) = samesign G_ICMP intpred(ult), [[COPY]](<2 x s32>), [[COPY1]]
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(<2 x s32>) = G_ANYEXT %2(<2 x s1>)
  ; CHECK-NEXT:   $d0 = COPY [[ANYEXT]](<2 x s32>)
  ; CHECK-NEXT:   RET_ReallyLR implicit $d0
entry:
  %result = icmp samesign ult <2 x i32> %a, %b
  ret <2 x i1> %result
}

define <2 x i1> @call_icmp_vector(<2 x i32> %a, <2 x i32> %b) {
  ; CHECK-LABEL: name: call_icmp_vector
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $d0, $d1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<2 x s32>) = COPY $d0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(<2 x s32>) = COPY $d1
  ; CHECK-NEXT:   [[ICMP:%[0-9]+]]:_(<2 x s1>) = G_ICMP intpred(ult), [[COPY]](<2 x s32>), [[COPY1]]
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(<2 x s32>) = G_ANYEXT [[ICMP]](<2 x s1>)
  ; CHECK-NEXT:   $d0 = COPY [[ANYEXT]](<2 x s32>)
  ; CHECK-NEXT:   RET_ReallyLR implicit $d0
entry:
  %result = icmp ult <2 x i32> %a, %b
  ret <2 x i1> %result
}

define i1 @call_icmp(i32 %a) {
  ; CHECK-LABEL: name: call_icmp
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 3
  ; CHECK-NEXT:   [[ICMP:%[0-9]+]]:_(s1) = G_ICMP intpred(ult), [[COPY]](s32), [[C]]
  ; CHECK-NEXT:   [[ZEXT:%[0-9]+]]:_(s8) = G_ZEXT [[ICMP]](s1)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[ZEXT]](s8)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
entry:
  %result = icmp ult i32 %a, 3
  ret i1 %result
}

define i1 @call_icmp_samesign(i32 %a) {
  ; CHECK-LABEL: name: call_icmp_samesign
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 3
  ; CHECK-NEXT:   %2:_(s1) = samesign G_ICMP intpred(ult), [[COPY]](s32), [[C]]
  ; CHECK-NEXT:   [[ZEXT:%[0-9]+]]:_(s8) = G_ZEXT %2(s1)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[ZEXT]](s8)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
entry:
  %result = icmp samesign ult i32 %a, 3
  ret i1 %result
}
