; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx900 -mattr=-flat-for-global -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=fiji -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=kaveri -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefix=GFX7 %s


define amdgpu_kernel void @s_pack_v2f16(ptr addrspace(4) %in0, ptr addrspace(4) %in1) #0 {
; GFX9-LABEL: s_pack_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s4, s5
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: s_pack_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX8-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use s0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: s_pack_v2f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX7-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use s0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_endpgm
  %val0 = load volatile i32, ptr addrspace(4) %in0
  %val1 = load volatile i32, ptr addrspace(4) %in1
  %lo.i = trunc i32 %val0 to i16
  %hi.i = trunc i32 %val1 to i16
  %lo = bitcast i16 %lo.i to half
  %hi = bitcast i16 %hi.i to half
  %vec.0 = insertelement <2 x half> poison, half %lo, i32 0
  %vec.1 = insertelement <2 x half> %vec.0, half %hi, i32 1
  %vec.i32 = bitcast <2 x half> %vec.1 to i32

  call void asm sideeffect "; use $0", "s"(i32 %vec.i32) #0
  ret void
}

define amdgpu_kernel void @s_pack_v2f16_imm_lo(ptr addrspace(4) %in1) #0 {
; GFX9-LABEL: s_pack_v2f16_imm_lo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, 0x1234, s0
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: s_pack_v2f16_imm_lo:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s0, 0x1234
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use s0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: s_pack_v2f16_imm_lo:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s0, 0x1234
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use s0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_endpgm
  %val1 = load i32, ptr addrspace(4) %in1
  %hi.i = trunc i32 %val1 to i16
  %hi = bitcast i16 %hi.i to half
  %vec.0 = insertelement <2 x half> poison, half 0xH1234, i32 0
  %vec.1 = insertelement <2 x half> %vec.0, half %hi, i32 1
  %vec.i32 = bitcast <2 x half> %vec.1 to i32

  call void asm sideeffect "; use $0", "s"(i32 %vec.i32) #0
  ret void
}

define amdgpu_kernel void @s_pack_v2f16_imm_hi(ptr addrspace(4) %in0) #0 {
; GFX9-LABEL: s_pack_v2f16_imm_hi:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, 0x1234
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: s_pack_v2f16_imm_hi:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX8-NEXT:    s_or_b32 s0, s0, 0x12340000
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use s0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: s_pack_v2f16_imm_hi:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX7-NEXT:    s_or_b32 s0, s0, 0x12340000
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use s0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_endpgm
  %val0 = load i32, ptr addrspace(4) %in0
  %lo.i = trunc i32 %val0 to i16
  %lo = bitcast i16 %lo.i to half
  %vec.0 = insertelement <2 x half> poison, half %lo, i32 0
  %vec.1 = insertelement <2 x half> %vec.0, half 0xH1234, i32 1
  %vec.i32 = bitcast <2 x half> %vec.1 to i32

  call void asm sideeffect "; use $0", "s"(i32 %vec.i32) #0
  ret void
}

define amdgpu_kernel void @v_pack_v2f16(ptr addrspace(1) %in0, ptr addrspace(1) %in1) #0 {
; GFX9-LABEL: v_pack_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v2, v1, s0
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: v_pack_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_load_dword v1, v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_mov_b32 s0, 0x1000504
; GFX8-NEXT:    v_perm_b32 v0, v0, v1, s0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: v_pack_v2f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX7-NEXT:    s_mov_b32 s7, 0x100f000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX7-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use v0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %in0.gep = getelementptr inbounds i32, ptr addrspace(1) %in0, i64 %tid.ext
  %in1.gep = getelementptr inbounds i32, ptr addrspace(1) %in1, i64 %tid.ext
  %val0 = load volatile i32, ptr addrspace(1) %in0.gep
  %val1 = load volatile i32, ptr addrspace(1) %in1.gep
  %lo.i = trunc i32 %val0 to i16
  %hi.i = trunc i32 %val1 to i16
  %lo = bitcast i16 %lo.i to half
  %hi = bitcast i16 %hi.i to half
  %vec.0 = insertelement <2 x half> poison, half %lo, i32 0
  %vec.1 = insertelement <2 x half> %vec.0, half %hi, i32 1
  %vec.i32 = bitcast <2 x half> %vec.1 to i32
  call void asm sideeffect "; use $0", "v"(i32 %vec.i32) #0
  ret void
}

define amdgpu_kernel void @v_pack_v2f16_user(ptr addrspace(1) %in0, ptr addrspace(1) %in1) #0 {
; GFX9-LABEL: v_pack_v2f16_user:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, 0x5040100
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_perm_b32 v0, v2, v1, s0
; GFX9-NEXT:    v_add_u32_e32 v0, 9, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: v_pack_v2f16_user:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_load_dword v1, v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_mov_b32 s0, 0x1000504
; GFX8-NEXT:    s_mov_b32 s3, 0x1100f000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_perm_b32 v0, v0, v1, s0
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 9, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: v_pack_v2f16_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0x100f000
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX7-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 9, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %in0.gep = getelementptr inbounds i32, ptr addrspace(1) %in0, i64 %tid.ext
  %in1.gep = getelementptr inbounds i32, ptr addrspace(1) %in1, i64 %tid.ext
  %val0 = load volatile i32, ptr addrspace(1) %in0.gep
  %val1 = load volatile i32, ptr addrspace(1) %in1.gep
  %lo.i = trunc i32 %val0 to i16
  %hi.i = trunc i32 %val1 to i16
  %lo = bitcast i16 %lo.i to half
  %hi = bitcast i16 %hi.i to half
  %vec.0 = insertelement <2 x half> poison, half %lo, i32 0
  %vec.1 = insertelement <2 x half> %vec.0, half %hi, i32 1
  %vec.i32 = bitcast <2 x half> %vec.1 to i32
  %foo = add i32 %vec.i32, 9
  store volatile i32 %foo, ptr addrspace(1) poison
  ret void
}

define amdgpu_kernel void @v_pack_v2f16_imm_lo(ptr addrspace(1) %in1) #0 {
; GFX9-LABEL: v_pack_v2f16_imm_lo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_movk_i32 s0, 0x1234
; GFX9-NEXT:    v_perm_b32 v0, v0, s0, v1
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: v_pack_v2f16_imm_lo:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_or_b32_e32 v0, 0x1234, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: v_pack_v2f16_imm_lo:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX7-NEXT:    s_mov_b32 s3, 0x100f000
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, 0x1234, v0
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use v0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %in1.gep = getelementptr inbounds i32, ptr addrspace(1) %in1, i64 %tid.ext
  %val1 = load volatile i32, ptr addrspace(1) %in1.gep
  %hi.i = trunc i32 %val1 to i16
  %hi = bitcast i16 %hi.i to half
  %vec.0 = insertelement <2 x half> poison, half 0xH1234, i32 0
  %vec.1 = insertelement <2 x half> %vec.0, half %hi, i32 1
  %vec.i32 = bitcast <2 x half> %vec.1 to i32
  call void asm sideeffect "; use $0", "v"(i32 %vec.i32) #0
  ret void
}

define amdgpu_kernel void @v_pack_v2f16_inline_imm_lo(ptr addrspace(1) %in1) #0 {
; GFX9-LABEL: v_pack_v2f16_inline_imm_lo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_movk_i32 s0, 0x4400
; GFX9-NEXT:    v_perm_b32 v0, v0, s0, v1
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: v_pack_v2f16_inline_imm_lo:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_or_b32_e32 v0, 0x4400, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: v_pack_v2f16_inline_imm_lo:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX7-NEXT:    s_mov_b32 s3, 0x100f000
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, 0x4400, v0
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use v0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %in1.gep = getelementptr inbounds i32, ptr addrspace(1) %in1, i64 %tid.ext
  %val1 = load volatile i32, ptr addrspace(1) %in1.gep
  %hi.i = trunc i32 %val1 to i16
  %hi = bitcast i16 %hi.i to half
  %vec.0 = insertelement <2 x half> poison, half 4.0, i32 0
  %vec.1 = insertelement <2 x half> %vec.0, half %hi, i32 1
  %vec.i32 = bitcast <2 x half> %vec.1 to i32
  call void asm sideeffect "; use $0", "v"(i32 %vec.i32) #0
  ret void
}

define amdgpu_kernel void @v_pack_v2f16_imm_hi(ptr addrspace(1) %in0) #0 {
; GFX9-LABEL: v_pack_v2f16_imm_hi:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_movk_i32 s0, 0x1234
; GFX9-NEXT:    v_perm_b32 v0, s0, v0, v1
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: v_pack_v2f16_imm_hi:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x12340000
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: v_pack_v2f16_imm_hi:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX7-NEXT:    s_mov_b32 s3, 0x100f000
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-NEXT:    v_or_b32_e32 v0, 0x12340000, v0
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use v0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %in0.gep = getelementptr inbounds i32, ptr addrspace(1) %in0, i64 %tid.ext
  %val0 = load volatile i32, ptr addrspace(1) %in0.gep
  %lo.i = trunc i32 %val0 to i16
  %lo = bitcast i16 %lo.i to half
  %vec.0 = insertelement <2 x half> poison, half %lo, i32 0
  %vec.1 = insertelement <2 x half> %vec.0, half 0xH1234, i32 1
  %vec.i32 = bitcast <2 x half> %vec.1 to i32
  call void asm sideeffect "; use $0", "v"(i32 %vec.i32) #0
  ret void
}

define amdgpu_kernel void @v_pack_v2f16_inline_f16imm_hi(ptr addrspace(1) %in0) #0 {
; GFX9-LABEL: v_pack_v2f16_inline_f16imm_hi:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_movk_i32 s0, 0x3c00
; GFX9-NEXT:    v_perm_b32 v0, s0, v0, v1
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: v_pack_v2f16_inline_f16imm_hi:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfrev_b32_e32 v1, 60
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: v_pack_v2f16_inline_f16imm_hi:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX7-NEXT:    s_mov_b32 s3, 0x100f000
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-NEXT:    v_or_b32_e32 v0, 0x3c000000, v0
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use v0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %in0.gep = getelementptr inbounds i32, ptr addrspace(1) %in0, i64 %tid.ext
  %val0 = load volatile i32, ptr addrspace(1) %in0.gep
  %lo.i = trunc i32 %val0 to i16
  %lo = bitcast i16 %lo.i to half
  %vec.0 = insertelement <2 x half> poison, half %lo, i32 0
  %vec.1 = insertelement <2 x half> %vec.0, half 1.0, i32 1
  %vec.i32 = bitcast <2 x half> %vec.1 to i32
  call void asm sideeffect "; use $0", "v"(i32 %vec.i32) #0
  ret void
}

define amdgpu_kernel void @v_pack_v2f16_inline_imm_hi(ptr addrspace(1) %in0) #0 {
; GFX9-LABEL: v_pack_v2f16_inline_imm_hi:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v0, 64, v0, v1
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: v_pack_v2f16_inline_imm_hi:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x400000
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: v_pack_v2f16_inline_imm_hi:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX7-NEXT:    s_mov_b32 s3, 0x100f000
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-NEXT:    v_or_b32_e32 v0, 0x400000, v0
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use v0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %in0.gep = getelementptr inbounds i32, ptr addrspace(1) %in0, i64 %tid.ext
  %val0 = load volatile i32, ptr addrspace(1) %in0.gep
  %lo.i = trunc i32 %val0 to i16
  %lo = bitcast i16 %lo.i to half
  %vec.0 = insertelement <2 x half> poison, half %lo, i32 0
  %vec.1 = insertelement <2 x half> %vec.0, half 0xH0040, i32 1
  %vec.i32 = bitcast <2 x half> %vec.1 to i32
  call void asm sideeffect "; use $0", "v"(i32 %vec.i32) #0
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
